﻿
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Reflection
Imports System.Runtime.InteropServices
Imports System.Text
Imports ACPDFCREACTIVEX
Imports AxACPDFCREACTIVEX


Public Class Form1
    Const StrLicenseTo As String = "Amyuni PDF Creator Evaluation"

    Const StrActivationCode As String =
        "07EFCDAB010001004282943F13F19A88F332D9E781E40460726D79A42847A1BDE06DB61C1BE94E2D90424BF8762385335F9D6884E9FC"


    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        axPDF.SetLicenseKey(StrLicenseTo, StrActivationCode)
        axPDF.ScaleToWindow = acScaleConstants.acScaleBoth
        axPDF.RulerSize = 0
    End Sub

    ''' <summary>
    '''     This method illustrates how to open a PDF document and create and add a text object onto this document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub CreateTextObject_Click(sender As Object, e As EventArgs) Handles CreateTextObject.Click
        'When set to True, the control is refreshed each time a property is modified
        axPDF.AutoRefresh = 0
        'Set to False to reduce flicker
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        axPDF.OpenEx(requiredPath & "\Source_Docs\CreateTextObject.pdf", "")
        axPDF.ScaleToWindow = acScaleConstants.acScaleBoth

        Try
            'Put the control in Design mode
            axPDF.ReportState = ReportStateConstants.acReportStateDesign

            'Create a text object
            axPDF.CreateObject(ObjectTypeConstants.acObjectTypeText, "acObjectTypeText")

            Dim obj As IacObject = axPDF.GetObjectByName("acObjectTypeText")
            'Position the Object
            obj("Left") = 0
            obj("Top") = 0
            obj("Right") = 3000
            obj("Bottom") = 1000
            obj("BackColor") = 192
            obj("TextFont") = "Arial,24,0,0,0"
            obj("Text") = "Amyuni Tech"

            'Put the control back into run mode
            axPDF.ReportState = ReportStateConstants.acReportStateRun

            'save the new document
            axPDF.Save(requiredPath & "\Resulting_Docs\CreateTextObject_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
            axPDF.AutoRefresh = 1
            'Set to True to render change


            axPDF.Refresh()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ''' <summary>
    '''     This method illustrates how to draw a highlighter object
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnDrawHighlight_Click(sender As Object, e As EventArgs) Handles btnDrawHighlight.Click
        'Put the control in Annotate Mode
        axPDF.ReportState = ReportStateConstants.acReportStateAnnotate
        axPDF.DoCommandTool(CommandToolConstants.acCommandToolHighlight)
    End Sub

    ''' <summary>
    '''     This method illustrates how to create a Table object
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnCreateTable_Click(sender As Object, e As EventArgs) Handles btnCreateTable.Click
        'Put the control in design mode
        axPDF.ReportState = ReportStateConstants.acReportStateDesign

        'This will create a PDF document with 4 pages
        For intCtr = 1 To 4

            'Get one table object per page
            axPDF.CreateObject(ObjectTypeConstants.acObjectTypeTable, "acTable" & intCtr)

            Dim objTable As IacObject = axPDF.GetObjectByName("acTable" & intCtr)
            'position the table object on each page
            objTable("Left") = 0
            objTable("Top") = 0
            objTable("Right") = axPDF.PageWidth.ToString()
            objTable("Bottom") = axPDF.PageLength.ToString()

            'Table will consist of 20 rows and 20 columns
            objTable("Rows") = 20
            objTable("Columns") = 20

            For j = 1 To 19
                Dim objTableCell As IacObject = axPDF.GetObjectByName("acTable" & intCtr & ".Cells[" & j & "," & j & "]")

                'This illustrates how to change attributes on particular cells
                objTableCell("BorderWidth") = 1
                objTableCell("BorderColor") = 192
                objTableCell("HorzBorders") = 3
                objTableCell("VertBorders") = 3
                objTableCell("BackColor") = "FF0000"

                'This will add text to the first cell on the first table
                axPDF.set_ObjectAttribute("acTable1.Cells[1,1]", "Font", "Arial,40,0,0,0,0")
                objTableCell("Text") = intCtr.ToString() & j.ToString()
            Next

            'only add upto 4 pages
            If intCtr <> 4 Then
                'This will add a page
                axPDF.AddPage(intCtr)
            End If
        Next

        'Put the control back into Run state
        axPDF.ReportState = ReportStateConstants.acReportStateRun

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        'Save resulting PDF document
        axPDF.Save(requiredPath & "\Resulting_Docs\CreateTable_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
    End Sub


    ''' <summary>
    '''     This method illustrates how to add pages to a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnCreateMultiPages_Click(sender As Object, e As EventArgs) Handles btnCreateMultiPages.Click
        Try
            'Create 10 pages
            For i = 1 To 10

                'Create an object with unique object name
                axPDF.CreateObject(ObjectTypeConstants.acObjectTypeText, "acTextObject" & i)
                Dim objText As IacObject = axPDF.GetObjectByName("acTextObject" & i)

                objText("Left") = 0
                objText("Top") = 0
                objText("Right") = 1500
                objText("Bottom") = 1000
                objText("TextFont") = "Arial,40,0,0,0"
                objText("Text") = "Page: " & i

                If i <> 10 Then
                    axPDF.AddPage(i)
                End If
            Next

            'Put the control back into Run state
            axPDF.ReportState = ReportStateConstants.acReportStateRun

            'get startup path for temp working files
            Dim requiredPath As String =
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(
                            Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))
            'Save resulting PDF document
            axPDF.Save(requiredPath & "\Resulting_Docs\CreateMultiPage_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The RedrawObject method redraws the object referenced by Object. This can be called after changing the object’s
    '''     properties to refresh the object.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnReDrawObject_Click(sender As Object, e As EventArgs) Handles btnReDrawObject.Click
        Try
            axPDF.ReportState = ReportStateConstants.acReportStateDesign

            axPDF.CreateObject(ObjectTypeConstants.acObjectTypeFrame, "acTypeFrame")
            Dim objFrame As IacObject = axPDF.GetObjectByName("acTypeFrame")

            objFrame("Left") = 200
            objFrame("Top") = 200
            objFrame("Right") = 600
            objFrame("Bottom") = 400

            'refresh the object when all its properties have been defined

            axPDF.RedrawObject("acTypeFrame")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to retrieve current active tool
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnActiveTool_Click(sender As Object, e As EventArgs) Handles btnActiveTool.Click
        '
        ' The ActiveTool function returns the tool that is currently active in the view 
        '             

        axPDF.ReportState = ReportStateConstants.acReportStateAnnotate

        'in this example, we are using the acObjectTypeHighlight object
        axPDF.InsertObject(ObjectTypeConstants.acObjectTypeHighlight)

        MessageBox.Show(axPDF.ActiveTool().ToString())
    End Sub


    ''' <summary>
    '''     The LockAllObjects method is used to lock/unlock all objects on the current page.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnLockAllObjects_Click(sender As Object, e As EventArgs) Handles BtnLockAllObjects.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.ReportState = ReportStateConstants.acReportStateDesign

            axPDF.CreateObject(ObjectTypeConstants.acObjectTypeText, "acTextObject")
            Dim objText As IacObject = axPDF.GetObjectByName("acTextObject")

            objText("Text") = "This is a text object"
            objText("Left") = 0
            objText("Top") = 0
            objText("Right") = 1500
            objText("Bottom") = 200
            objText("BackColor") = "00AA00"

            axPDF.ReportState = ReportStateConstants.acReportStateRun

            'Set this parameter True (or 1) to lock, False (or 0) to unlock.
            axPDF.LockAllObjects(1)

            'save the new document
            axPDF.Save(requiredPath & "\Resulting_Docs\LockAllObjects_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to create Checkboxes
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnCreateCheckButton_Click(sender As Object, e As EventArgs) Handles BtnCreateCheckButton.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))
        Try
            axPDF.ReportState = ReportStateConstants.acReportStateDesign

            axPDF.CreateObject(ObjectTypeConstants.acObjectTypeCheckBox, "CheckBox")
            Dim objCheckBox As IacObject = axPDF.GetObjectByName("CheckBox")

            'Position object
            objCheckBox("Top") = 1000
            objCheckBox("Left") = 1000
            objCheckBox("Right") = 1500
            objCheckBox("Bottom") = 1700
            objCheckBox("BorderWidth") = 1

            '
            '                    0: acCheckBox
            '                    1: acPushButton
            '                    2: acRadioButton
            '                 


            objCheckBox("ButtonType") = 0

            'button is checked
            objCheckBox("Text") = "On"

            axPDF.ReportState = ReportStateConstants.acReportStateRun

            'save the new document
            axPDF.Save(requiredPath & "\Resulting_Docs\CreateCheckButton_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to Load an image object from a stream
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnLoadPictureFile_Click(sender As Object, e As EventArgs) Handles BtnLoadPictureFile.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        'When set to True, the control is refreshed each time a property is modified
        axPDF.AutoRefresh = 0
        'Set to False to reduce flicker
        Dim bpc = 0
        axPDF.ZoomFactor = 140
        axPDF.ReportState = ReportStateConstants.acReportStateDesign

        ' Create a new bitmap.
        ' Or get one from an already created Stream
        Dim bmp As New Bitmap(requiredPath & "\Source_Docs\benchmark_chart.jpg")
        axPDF.ScaleToWindow = acScaleConstants.acScaleBoth

        'create Picture Object
        axPDF.CreateObject(ObjectTypeConstants.acObjectTypePicture, "imageno")
        Dim objTypePicture As IacObject = axPDF.GetObjectByName("imageno")

        Select Case bmp.PixelFormat
            Case PixelFormat.Format24bppRgb
                bpc = 24
                Exit Select

            Case PixelFormat.Format1bppIndexed
                bpc = 1
                Exit Select
            Case Else


                Dim bm As New Bitmap(bmp.Width, bmp.Height, PixelFormat.Format24bppRgb)

                'obtain a Graphics object for the new image and draw the old image 
                'onto it using DrawImage 


                Dim gr As Graphics = Graphics.FromImage(bm)
                Dim rect As New Rectangle(0, 0, bm.Width, bm.Height)
                gr.DrawImage(bm, rect, 0, 0, bm.Width, bm.Height,
                             GraphicsUnit.Pixel)
                Exit Select
        End Select

        ' Lock the bitmap's bits.  
        Dim rect1 As New Rectangle(0, 0, bmp.Width, bmp.Height)
        Dim bmpData As BitmapData = bmp.LockBits(rect1, ImageLockMode.ReadWrite, bmp.PixelFormat)

        ' Declare an array to hold the bytes of the bitmap.
        Dim bytes As Integer = bmp.Height * bmpData.Stride
        Dim rgbValues = New Byte(bytes - 1) {}

        ' Copy the RGB values into the array.
        For scanLine As Integer = bmp.Height - 1 To 0 Step -1
            ' Get the address of the Nth scanline.
            Dim ptr As New IntPtr(CInt(bmpData.Scan0) + scanLine * bmpData.Stride)

            Marshal.Copy(ptr, rgbValues, bmpData.Stride * (bmp.Height - scanLine - 1), bmpData.Stride)
        Next

        'set picture paramters
        objTypePicture("Top") = 0
        objTypePicture("Left") = 0
        objTypePicture("Bottom") = 5000
        objTypePicture("Right") = 5000
        objTypePicture("BitsPerComponent") = bpc
        objTypePicture("BorderWidth") = 2
        objTypePicture("BitmapWidth") = bmp.Width
        objTypePicture("BitmapHeight") = bmp.Height
        objTypePicture("BitsPerComponent") = bpc
        objTypePicture("BitmapData") = rgbValues

        ' Unlock the bits.
        bmp.UnlockBits(bmpData)

        'Change report state
        axPDF.ReportState = ReportStateConstants.acReportStateRun

        axPDF.AutoRefresh = 1
        'Set to True to render change
        axPDF.Refresh()

        'save the new document
        axPDF.Save(requiredPath & "\Resulting_Docs\LoadPicFile_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
    End Sub


    ''' <summary>
    '''     The AutoHyperlinks method automatically converts text in the document that contains
    '''     hyperlinks into active hyperlinks that can be clicked.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnAutoHyperlinks_Click(sender As Object, e As EventArgs) Handles BtnAutoHyperlinks.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\createhyperlinks.pdf", "")

            axPDF.ReportState = ReportStateConstants.acReportStateDesign
            axPDF.AutoHyperlinks("http://;mailto:")

            axPDF.DoCommandTool(CommandToolConstants.acCommandToolRunDocument)

            axPDF.Save(requiredPath & "\Resulting_Docs\AutoHyperlinks_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to insert an image into a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnCreatePictureObject_Click(sender As Object, e As EventArgs) Handles BtnCreatePictureObject.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))


        Try
            axPDF.Open(requiredPath & "\Source_Docs\text.pdf", "")
            axPDF.ReportState = ReportStateConstants.acReportStateDesign

            axPDF.CreateObject(ObjectTypeConstants.acObjectTypePicture, "ObjectTypePicture")
            Dim objTypePicture As IacObject = axPDF.GetObjectByName("ObjectTypePicture")

            'Position Object
            objTypePicture("Left") = 0
            objTypePicture("Top") = 0
            objTypePicture("Right") = CInt(axPDF.PageWidth)
            objTypePicture("Bottom") = CInt(axPDF.PageLength)
            objTypePicture("FileName") = requiredPath & "\Source_Docs\demo_logo.jpg"

            'This will add the image in the background
            'select the object
            objTypePicture.Selected = 1

            'apply changes
            axPDF.DoCommandTool(CommandToolConstants.acCommandToolBringBackward)

            axPDF.ReportState = ReportStateConstants.acReportStateRun

            axPDF.Save(requiredPath & "\Resulting_Docs\CreatePicObject_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to create a polygon object
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnCreatePolygon_Click(sender As Object, e As EventArgs) Handles BtnCreatePolygon.Click
        axPDF.DoCommandTool(CommandToolConstants.acCommandToolDesignMode)

        Dim ops = New Integer(5) {}
        ops(0) = 6
        ops(1) = 2
        ops(2) = 2
        ops(3) = 2
        ops(4) = 2
        ops(5) = 2

        axPDF.CreateObject(ObjectTypeConstants.acObjectTypePolygon, "Polygon")
        Dim objTypePolygon As IacObject = axPDF.GetObjectByName("Polygon")

        objTypePolygon("Top") = 1000
        objTypePolygon("Left") = 1000
        objTypePolygon("Right") = 5500
        objTypePolygon("Bottom") = 6500

        objTypePolygon("Points") = 6

        objTypePolygon("XPoints") = New Integer() {0, 3000, 9000, 9000, 3500, 0}
        objTypePolygon("YPoints") = New Integer() {5000, 9000, 7500, 2000, 2000, 5000}

        objTypePolygon("Text") = "Amyuni Technologies"
        objTypePolygon("Operations") = ops
        objTypePolygon("StrokeColor") = &HFF00

        axPDF.DoCommandTool(CommandToolConstants.acCommandToolRunDocument)

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))
        'save the new document
        axPDF.Save(requiredPath & "\Resulting_Docs\CreatePoly_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
    End Sub


    ''' <summary>
    '''     This method illustrates how to clear the control
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnClearControl_Click(sender As Object, e As EventArgs) Handles BtnClearControl.Click
        axPDF.InitBlank()
        axPDF.Refresh()
    End Sub


    ''' <summary>
    '''     This method illustrates how to create and add bookmarks to existing PDF documents
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnCreateBookmarks_Click(sender As Object, e As EventArgs) Handles BtnCreateBookmarks.Click
        'Create bookmark objects
        Dim acBookRoot As acBookmark = New acBookmarkClass()
        Dim acBookChild As acBookmark = New acBookmarkClass()
        Dim acBook As acBookmark = New acBookmarkClass()

        Try
            'get startup path for temp working files
            Dim requiredPath As String =
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(
                            Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

            axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")


            'When set to True, the control is refreshed each time a property is modified
            axPDF.AutoRefresh = 0
            'Set to False to reduce flicker
            'create a rootbook mark object
            acBookRoot = axPDF.RootBookmark
            acBookRoot.InsertChild(1, "This is a bookmark", "", acBookChild)

            axPDF.CurrentPage = 1

            Dim intPageCtr As Integer = axPDF.PageCount

            For iCtr = 1 To intPageCtr
                axPDF.CurrentPage = iCtr
                acBookChild.InsertChild(iCtr, "Bookmark on Page: " & iCtr, "", acBook)
            Next

            axPDF.Save(requiredPath & "\Resulting_Docs\CreateBookmarks_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)

            'TThe Bookmark object’s ReachBookmark method displays the 
            'document location pointed to by that bookmark.
            axPDF.ReachBookmark("Bookmark on Page: 9")
            axPDF.Refresh()
            '
            axPDF.AutoRefresh = 1
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to draw an Arrow object on to a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnCreateArrowObject_Click(sender As Object, e As EventArgs) Handles BtnCreateArrowObject.Click
        axPDF.DoCommandTool(CommandToolConstants.acCommandToolArrow)
    End Sub


    ''' <summary>
    '''     This function creates a stickynote
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnCreateStickyNote_Click(sender As Object, e As EventArgs) Handles BtnCreateStickyNote.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        'When set to True, the control is refreshed each time a property is modified
        axPDF.AutoRefresh = 0
        'Set to False to reduce flicker
        'Open PDF document			
        axPDF.Open(requiredPath & "\Source_Docs\text.pdf", "")
        axPDF.ScaleToWindow = acScaleConstants.acScaleBoth

        'Put document in Annoation State
        'This will allow you to add annotations without your users have 
        'the ability to edit the PDF document beign viewed
        axPDF.ReportState = ReportStateConstants.acReportStateAnnotate

        'Create Annation
        axPDF.CreateObject(ObjectTypeConstants.acObjectTypeStickyNote, "StickyNote")
        Dim objStickyNote As IacObject = axPDF.GetObjectByName("StickyNote")

        'Position Object
        objStickyNote("Note Top") = 1000
        objStickyNote("Note Left") = 1000
        objStickyNote("Note Right") = 5000
        objStickyNote("Note Bottom") = 5000

        objStickyNote("Icon Top") = 950
        objStickyNote("Icon Left") = 1000
        objStickyNote("Icon Right") = 1300
        objStickyNote("Icon Bottom") = 1250

        objStickyNote("Open") = True
        objStickyNote("Text") = "Amyuni Tech"

        'Apply changes
        axPDF.DoCommandTool(CommandToolConstants.acCommandToolRunDocument)

        'save the new document
        axPDF.Save(requiredPath & "\Resulting_Docs\CreateStickyNote_resulting.pdf",
                   FileSaveOptionConstants.acFileSaveView)

        axPDF.AutoRefresh = 1
        'Set to True to render change
        axPDF.Refresh()
    End Sub


    ''' <summary>
    '''     The Encrypt method secures the PDF document and prevents it from unauthorized access. Two passwords, the owner
    '''     password and user password, are associated to an encrypted PDF document.
    '''     This feature is only available in the version of the PDF Creator bundled with the Amyuni PDF Suite
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnEncryptDocument_Click(sender As Object, e As EventArgs) Handles BtnEncryptDocument.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")
            '
            '                  A blank password:
            '                 -----------------
            '                 The user is not prompted for a password when opening a
            '                 document, but is restricted to the operations allowed by the
            '                 author.*
            '
            '                 The same password as the owner:
            '                 -------------------------------
            '                 The user is prompted for a password and the author of the
            '                 document will not be able to open this document as an owner
            '                 to change its security settings.
            '
            '                 A password different from the owner:
            '                 ------------------------------------
            '                 The user will not be able to open the document unless he/she
            '                 enters a valid password. When a valid password is entered,
            '                 the document can be viewed but its usage restricted to the
            '                 operations allowed by the author.
            '                 


            'axPDF.Encrypt("aaaaaa", "", -64);
            axPDF.Encrypt128("aaaaaa", "", -64)

            'save file

            axPDF.Save(requiredPath & "\Resulting_Docs\Encrypt_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to rotate a page
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnRotatePage_Click(sender As Object, e As EventArgs) Handles BtnRotatePage.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\text.pdf", "")

            'This rotates page 1
            axPDF.RotatePage(1, RotatePageConstants.acRotatePageLeft)

            axPDF.Save(requiredPath & "\Resulting_Docs\RotatePage_resulting.pdf", FileSaveOptionConstants.acFileSaveAll)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The ScrollWindow method can be used to scroll the document window by HorzScroll and VertScroll increments.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnScrollWindow_Click(sender As Object, e As EventArgs) Handles BtnScrollWindow.Click
        'Scroll the document window by HorzScroll and VertScroll increments
        axPDF.ScrollWindow(100, (axPDF.PageLength \ 2))

        'Parameters
        'HorzScroll
        '  The amount to scroll horizontally in twips
        'VertScroll
        '  The amount to scroll vertically in twips
        'scroll horizontally and vertically
        axPDF.ScrollWindow(100, 7000)
    End Sub


    ''' <summary>
    '''     This method illustrates how to use the SelectAllObjects()
    '''     method to change the text attribute and value on all objects on a page
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnSetAttributeForMultipleSelection_Click(sender As Object, e As EventArgs) _
        Handles BtnSetAttributeForMultipleSelection.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\objects.pdf", "")

            axPDF.ReportState = ReportStateConstants.acReportStateDesign

            'The SelectAllObjects method selects/unselects all objects on the current page.
            'Set SelectAllObjects to true
            axPDF.SelectAllObjects(1)

            axPDF.SetAttributeForMultipleSelection("TextFont", "Courier New,14,700,0,0")
            axPDF.SetAttributeForMultipleSelection("Text", "new values added")

            axPDF.DoCommandTool(CommandToolConstants.acCommandToolRunDocument)

            axPDF.Save(requiredPath & "\Resulting_Docs\SetAttributeForMultipleSelection_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveAll)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The SetPageNumbering method enables the developer to automatically number all pages of a document. Page
    '''     numbers are automatically adjusted when pages are added, removed or moved within the document.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnPageNumber_Click(sender As Object, e As EventArgs) Handles BtnPageNumber.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")
            axPDF.SetPageNumbering(acPageNumbersPositions.acPageNumbersPositionTopCenter, "Verdana,24,700,0,0", 0, 0,
                                   192, 1,
                                   "- Page #page of #pages -")

            axPDF.Save(requiredPath & "\Resulting_Docs\PageNumber_resulting.pdf", FileSaveOptionConstants.acFileSaveAll)

            axPDF.Refresh()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The DigitalSignature method is used to add a digital signature to a PDF document. Prior to digitally signing a
    '''     document, the users or developers should have on their systems a digital certificate that can be used to sign
    '''     documents. A user who receives a document that is digitally signed can verify if the digital signature is valid and
    '''     if the
    '''     document has been tempered with.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnDigitalSigntures_Click(sender As Object, e As EventArgs) Handles BtnDigitalSigntures.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\text.pdf", "")

            '	Signer name			1
            '                    Reason for signing	2
            '                    Location			4
            '                    Associated image	8
            '                    Date of signing		32
            '                    Signature type		64
            '                


            axPDF.DigitalSignature("Bob", "my reason", requiredPath & "\Source_Docs\sign.jpg", "Loaction", 1, 0,
                                   0, 800, 800, 101)
            ' 1 + 2 + 4 + 8 + 32 + 64 );
            axPDF.Save(requiredPath & "\Resulting_Docs\DigitalSignatures_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveAll)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to enumerate through fonts in a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnGetFonts_Click(sender As Object, e As EventArgs) Handles BtnGetFonts.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\objects.pdf", "")

            'Get array of objects
            Dim myObjArray = DirectCast(axPDF.get_ObjectAttribute("Document", "Fonts"), IacObject())

            For Each obj As acObject In myObjArray
                MessageBox.Show(obj("FontName").ToString())
            Next
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The Undo method is used to undo the latest action.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnUnDo_Click(sender As Object, e As EventArgs) Handles BtnUnDo.Click
        Try
            axPDF.DeleteObject("acTextObject", 1)

            'Read undo levels
            MessageBox.Show(axPDF.UndoLevels().ToString())

            'undo last action			
            axPDF.Undo()

            'Read undo levels

            'axPDF.Refresh ();;
            MessageBox.Show(axPDF.UndoLevels().ToString())
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The Redo method is used to redo the latest undone action.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnReDo_Click(sender As Object, e As EventArgs) Handles BtnReDo.Click
        Try
            axPDF.DeleteObject("acTextObject", 1)

            'Read undo levels
            MessageBox.Show(axPDF.UndoLevels().ToString())

            'undo last action			
            axPDF.Undo()

            'Read number of redo levels
            MessageBox.Show(axPDF.RedoLevels().ToString())

            'Redo latest undone action		
            axPDF.Redo()

            'Read number of redo levels
            MessageBox.Show(axPDF.RedoLevels().ToString())
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to insert a PDF document at the beginning of another document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnInsertPDFatBegin_Click(sender As Object, e As EventArgs) Handles BtnInsertPDFatBegin.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Dim iPageCount As Integer
        Dim iNewPageCount As Integer

        Dim strAppendFileName As String = requiredPath & "\Source_Docs\a.pdf"
        Dim strNewAppendedFileName As String = requiredPath & "\Resulting_Docs\InsertPDFBegin_resulting.pdf"

        Try
            'Open a (example) 10 page document to insert document into
            axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")

            'get total number of pages in current doc
            iPageCount = axPDF.PageCount

            'append and save file
            axPDF.Append(strAppendFileName, "")
            axPDF.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView)

            'open newly appended document 
            axPDF.Open(strNewAppendedFileName, "")

            'get new page count
            iNewPageCount = axPDF.PageCount

            'Move pages to correct locations (beginning)
            axPDF.MovePages((iPageCount + 1), (iNewPageCount - iPageCount), 1)

            'save file
            axPDF.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to insert a PDF document at the end of another document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnInsertPDFatEnd_Click(sender As Object, e As EventArgs) Handles BtnInsertPDFatEnd.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")

        axPDF.AutoRefresh = 0

        axPDF.Append(requiredPath & "\Source_Docs\a.pdf", "")

        'save file
        axPDF.Save(requiredPath & "\Resulting_Docs\InsertPDFatEnd_resulting.pdf", FileSaveOptionConstants.acFileSaveView)

        axPDF.Refresh()
        'I needed to add this to refresh control
        axPDF.AutoRefresh = 1
    End Sub


    ''' <summary>
    '''     This method illustrates how to insert a PDF document before the current page that is being rendered on the PDF
    '''     Creator control.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnInsertBeforeCurrentPage_Click(sender As Object, e As EventArgs) _
        Handles BtnInsertBeforeCurrentPage.Click
        Dim iPageCount As Integer
        Dim iCurrentPage As Integer
        Dim iNewPageCount As Integer

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Dim strAppendFileName As String = requiredPath & "\Source_Docs\a.pdf"
        Dim strNewAppendedFileName As String = requiredPath & "\Resulting_Docs\InsertBeforeCurrentPage_resulting.pdf"

        Try
            axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")

            axPDF.AutoRefresh = 0

            'to go page 4
            axPDF.CurrentPage = 4
            axPDF.Refresh()

            'get current page value
            iCurrentPage = axPDF.CurrentPage

            'get total number of pages in current doc
            iPageCount = axPDF.PageCount

            'append and save file
            axPDF.Append(strAppendFileName, "")
            axPDF.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView)

            'open newly appended document 
            axPDF.Open(strNewAppendedFileName, "")

            'get new page count
            iNewPageCount = axPDF.PageCount

            'Move pages to correct locations (beginning)
            axPDF.MovePages((iPageCount + 1), (iNewPageCount - iPageCount), iCurrentPage)

            'save file
            axPDF.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView)

            axPDF.Refresh()
            axPDF.AutoRefresh = 1
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to insert a PDF document after the current page that is being rendered on the PDF
    '''     Creator control.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnInsertAfterCurrentPage_Click(sender As Object, e As EventArgs) _
        Handles BtnInsertAfterCurrentPage.Click
        Dim iPageCount As Integer
        Dim iCurrentPage As Integer
        Dim iNewPageCount As Integer


        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Dim strAppendFileName As String = requiredPath & "\Source_Docs\a.pdf"
        Dim strNewAppendedFileName As String = requiredPath & "\Resulting_Docs\InsertBeforeCurrentPage_resulting.pdf"

        Try

            axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")

            axPDF.CurrentPage = 4
            axPDF.Refresh()

            'get current page value
            iCurrentPage = axPDF.CurrentPage

            'get total number of pages in current doc
            iPageCount = axPDF.PageCount

            'append and save file
            axPDF.Append(strAppendFileName, "")
            axPDF.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView)

            'open newly appended document 
            axPDF.Open(strNewAppendedFileName, "")

            'get new page count
            iNewPageCount = axPDF.PageCount

            'Move pages to correct locations (beginning)
            axPDF.MovePages((iPageCount + 1), (iNewPageCount - iPageCount), (iCurrentPage + 1))

            'save file
            axPDF.Save(strNewAppendedFileName, FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how use the COM object
    '''     In this method only pages 5 and 8 are being saved to a new file
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnSaveandCloseLibrary_Click(sender As Object, e As EventArgs) Handles BtnSaveandCloseLibrary.Click
        Dim pdf As New PDFCreactiveXClass()

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            pdf.OpenEx(requiredPath & "\Source_Docs\tenpages.pdf", "")
            pdf.SetLicenseKey(StrLicenseTo, StrActivationCode)

            pdf.StartSave(requiredPath & "\Resulting_Docs\SaveCloseLib_resulting.pdf",
                          FileSaveOptionConstants.acFileSaveView)
            pdf.SavePage(5)
            pdf.SavePage(8)


            pdf.EndSave()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method will trigger the SavePage event to fire
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnSavePageEvent_Click(sender As Object, e As EventArgs) Handles BtnSavePageEvent.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))


        Try
            axPDF.OpenEx(requiredPath & "\Source_Docs\tenpages.pdf", "")

            'save file

            axPDF.Save(requiredPath & "\Resulting_Docs\SavePageEvent_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This event is fired for each page saved by the control
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub axPDF_SavePageEvent(sender As Object, e As _IPDFCreactiveXEvents_SavePageEvent) _
        Handles axPDF.SavePageEvent
        'MessageBox.Show(e.pageNumber.ToString());
    End Sub


    ''' <summary>
    '''     The Print method is used to print the document to a specified printer.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnPrintPDFDocument_Click(sender As Object, e As EventArgs) Handles BtnPrintPDFDocument.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\text.pdf", "")

            'Parameters
            'PrinterName
            'If no printer name is specified, the document is printed to the default printer.
            'Prompt
            'If this parameter is set to True, the user is prompted with the printer selection dialog box.
            axPDF.Print("", 1)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The GetWarningLevel method is used to read any warnings generated when opening a document. The warnings are
    '''     related to features not supported by the PDF Creator.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnGetWarningLevel_Click(sender As Object, e As EventArgs) Handles BtnGetWarningLevel.Click
        '
        '             The GetWarningLevel function is used to read any warnings generated when opening the document 
        '             

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "Source_Docs\tenpages.pdf", "")
            MessageBox.Show(axPDF.GetWarningLevel().ToString())
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to use the StartSave() method.
    '''     The StartSave() method is used to start page by page saving of a document.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnSavePageByPage_Click(sender As Object, e As EventArgs) Handles BtnSavePageByPage.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            'axPDF.OpenEx(System.IO.Directory.GetCurrentDirectory() + "\\temp.pdf", "");
            axPDF.Open(requiredPath & "Source_Docs\tenpages.pdf", "")

            axPDF.StartSave(requiredPath & "Resulting_Docs\SavePage_resulting.pdf",
                            FileSaveOptionConstants.acFileSaveView)

            'This example saves pages 1 and 4 to new PDF document
            axPDF.SavePage(1)
            axPDF.SavePage(4)

            '' Save only from page 6 to page 10
            '                For n = startSave To endSave
            '                .SavePage n
            '                Next 


            axPDF.Modified = 0
            axPDF.EndSave()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to use the MovePages method.
    '''     The MovePages method moves one or more pages to another location within the document.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnMovePages_Click(sender As Object, e As EventArgs) Handles BtnMovePages.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "Source_Docs\tenpages.pdf", "")

            '
            '                 Parameters
            '                 ---------
            '                    PageNumber
            '                            Starting page
            '                    PageCount
            '                        Number of pages to move
            '                    Destination
            '                        Where to place the moved pages
            '                

            axPDF.MovePages(2, 1, 4)

            axPDF.Save(requiredPath & "Resulting_Docs\MovePages_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The DeletePage method deletes the page at a specified location.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnDeletePages_Click(sender As Object, e As EventArgs) Handles BtnDeletePages.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.Open(requiredPath & "Source_Docs\tenpages.pdf", "")

            'DeletePage ( int pagenumber , canundo)
            axPDF.DeletePage(2, 0)

            'Set modified flag to false
            'do not regenerate the document
            axPDF.Modified = 0

            axPDF.Save(requiredPath & "Resulting_Docs\DeletePage_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The DuplicatePage method duplicates the current page and adds it at a specified position. This method creates a
    '''     copy of the current page with all its contents and places this copy at the position specified by PageIndex.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnDuplicatePage_Click(sender As Object, e As EventArgs) Handles BtnDuplicatePage.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "Source_Docs\tenpages.pdf", "")

            'DuplicatePage ( int pageindex ) uses zero based index
            'Must set control to current page
            axPDF.CurrentPage = 2
            axPDF.DuplicatePage(4)

            axPDF.Save(requiredPath & "Resulting_Docs\DuplicatePages_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The EmbedFont sets font embedding option for specific fonts.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnEmbedFonts_Click(sender As Object, e As EventArgs) Handles BtnEmbedFonts.Click
        ' Font Options
        '            acEmbedFontOptionDefault = -1 (&HFFFFFFFF)
        '            acEmbedFontOptionFull = 2
        '            acEmbedFontOptionNoEmbed = 0
        '            acEmbedFontOptionPartial = 1
        '            


        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")
            axPDF.EmbedFont("Courier New", acEmbedFontOptions.acEmbedFontOptionFull)

            axPDF.Save(requiredPath & "\Resulting_Docs\EmbedFonts_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to use the ReachText() method which searches for text in a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnReachText_Click(sender As Object, e As EventArgs) Handles BtnReachText.Click
        '===============================================================
        '            'Parameters:
        '            'Option
        '            '-1 case sensitive search from the beginning of the document
        '            '0 case sensitive search from current position
        '            '1 search from the beginning of the document, case-insensitive
        '            '2 search from the current position, case-insensitive
        '
        '            'Text Text to search for
        '            'FontName If provided (not empty), the text has to be in the specified font
        '            'FontSize If provided (not 0), the text has to be in the specified font size
        '            'Bold, Italic The text has to be in the specified font style
        '            ===============================================================


        Dim intFoundIt As Integer
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\text.pdf", "")

            intFoundIt = axPDF.ReachText(ReachTextOptionConstants.acReachTextOptionCurrent, "change", "", 0, 0, 0)

            If intFoundIt = 0 Then
                MessageBox.Show($"Didn't find it!")
            Else
                MessageBox.Show($"Found it!")
            End If
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The AppendEx method can be used to append or concatenate a PDF file to the current document. Whenever possible,
    '''     it is recommended to call the Append method rather than the AppendEx method. The Append method is usually
    '''     more efficient.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnAppendExDocs_Click(sender As Object, e As EventArgs) Handles BtnAppendExDocs.Click
        'open a document to append using another instance of PDF Creator Control
        Dim pdf2 As New PDFCreactiveXClass()
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        pdf2.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")

        Try
            axPDF.Open(requiredPath & "\Source_Docs\a.pdf", "")

            'append PDF2 document to the current document
            axPDF.AppendEx(pdf2)

            axPDF.Save(requiredPath & "\Resulting_Docs\AppendEx_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The MergeEx method merges the contents of the current document into a specified PDF file.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnMergeExFiles_Click(sender As Object, e As EventArgs) Handles BtnMergeExFiles.Click
        '===============================================================
        '            'Option                     Option Value    Description
        '            'Repeat first pages             1          The first pages of the second document are repeated in the first Document
        '            'Second document above First    2           The contents of the second document are printed above the contents the first document
        '            ===============================================================


        'open first file in new object
        Dim pdf2 As New PDFCreactiveXClass()
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        pdf2.SetLicenseKey(StrLicenseTo, StrActivationCode)
        pdf2.Open(requiredPath & "\Source_Docs\a.pdf", "")

        Try
            axPDF.Open(requiredPath & "\Source_Docs\tenpages.pdf", "")

            axPDF.MergeEx(pdf2, 1)
            axPDF.Refresh()
            axPDF.DoCommandTool(CommandToolConstants.acCommandToolRunDocument)

            axPDF.Save(requiredPath & "\Resulting_Docs\MergeEx_resulting.pdf", FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The Merge method merges the contents of the current document into a specified PDF file.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnMergeFiles_Click(sender As Object, e As EventArgs) Handles BtnMergeFiles.Click
        '===============================================================
        '            'Option                     Option Value    Description
        '            'Repeat first pages             1          The first pages of the second document are repeated in the first Document
        '            'Second document above First    2          The contents of the second document are printed above the contents the first document
        '            ===============================================================


        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.OpenEx(requiredPath & "\Source_Docs\logo.pdf", "")
            axPDF.Merge(requiredPath & "\Source_Docs\text.pdf", "", 2)

            'save the new document
            axPDF.Save(requiredPath & "\Resulting_Docs\Merge_resulting.pdf", FileSaveOptionConstants.acFileSaveView)

            axPDF.Refresh()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The function illustrates how to append multi PDF documents.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnAppendMultiDocs_Click(sender As Object, e As EventArgs) Handles BtnAppendMultiDocs.Click
        'open a document to append using an instance of PDF Creator object
        Dim pdFdoc As New PDFCreactiveXClass()
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))


        Try
            pdFdoc.SetLicenseKey(StrLicenseTo, StrActivationCode)

            pdFdoc.Open(requiredPath & "\Source_Docs\text.pdf", "")

            'Example: Append other PDF documents
            pdFdoc.Append(requiredPath & "\Source_Docs\tenpages.pdf", "")
            pdFdoc.Append(requiredPath & "\Source_Docs\CreateTextObject.pdf", "")
            pdFdoc.Append(requiredPath & "\Source_Docs\logo.pdf", "")
            pdFdoc.Append(requiredPath & "\Source_Docs\a.pdf", "")


            pdFdoc.Save(requiredPath & "\Resulting_Docs\AppendMultipleDocs_resulting.pdf",
                        FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The GetObjectsInRectangle method gets all the objects that are in the specified rectangle. The objects are placed
    '''     in
    '''     a Safe Array.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnGetObjectsInRec_Click(sender As Object, e As EventArgs) Handles BtnGetObjectsInRec.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))
        Try
            axPDF.Open(requiredPath & "Source_Docs\CreateTextObject.pdf", "")

            'Get array of objects
            Dim myObjArray = DirectCast(axPDF.GetObjectsInRectangle(0, 0, 10000, 12000, 0), IacObject())

            For Each obj As IacObject In myObjArray
                'Check if it is a text object
                If obj("ObjectType").Equals(5) Then
                    'text property is not empty and exist
                    If obj("Text") IsNot Nothing Then
                        Dim l As Integer, t As Integer, r As Integer, b As Integer
                        obj.Coordinates(l, t, r, b)

                        'The DelimitedText method returns part of the text enclosed in a rectangle.
                        MessageBox.Show(obj.DelimitedText(l, t, r, b))
                    End If
                End If
            Next
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to retrieve the document properties of a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnGetDocProperties_Click(sender As Object, e As EventArgs) Handles BtnGetDocProperties.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\GetDocProp.pdf", "")

            MessageBox.Show(axPDF.get_ObjectAttribute("Document", "Author").ToString(), $"Author")
            MessageBox.Show(axPDF.get_ObjectAttribute("Document", "Creator").ToString(), $"Creator")
            MessageBox.Show(axPDF.get_ObjectAttribute("Document", "Producer").ToString(), $"Producer")
            MessageBox.Show(axPDF.get_ObjectAttribute("Document", "Subject").ToString(), $"Subject")
            MessageBox.Show(axPDF.get_ObjectAttribute("Document", "Title").ToString(), $"Title")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The DeleteObject method can be used to delete an object referenced by the Object parameter from the PDF
    '''     document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnDeleteObject_Click(sender As Object, e As EventArgs) Handles BtnDeleteObject.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.OpenEx(requiredPath & "\Source_Docs\stickynote.pdf", "")

            'Get array of objects
            Dim myObjArray = DirectCast(axPDF.get_ObjectAttribute("Pages[1]", "Objects"), IacObject())

            For Each obj As IacObject In myObjArray
                'Check if object is a Picture object
                If obj("ObjectType").Equals(22) Then
                    'Parameters
                    'Object
                    'An Object name to delete
                    '        CanUndo
                    'This parameter should be set to True if the user Is allowed to undo the delete object action. This Is usually
                    '            the case when this method Is called from a menu Or other user interface. This parameter should be set to
                    '            False if the user cannot undo this action; this Is more efficient And avoids the overhead related to
                    '            managing the Undo list.
                    '                         

                    axPDF.DeleteObject(obj("Name").ToString(), 0)
                End If
            Next

            'save the new document
            axPDF.Save(requiredPath & "\Resulting_Docs\DeleteObject_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This method illustrates how to retrieve the value of a field object in a PDF document.
    '''     This is typically used to retrieve values from form data
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnGetTextValue_Click(sender As Object, e As EventArgs) Handles BtnGetTextValue.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        axPDF.OpenEx(requiredPath & "\Source_Docs\CreateTextObject.pdf", "")

        Try
            'Get array of objects
            Dim myObjArray = DirectCast(axPDF.get_ObjectAttribute("Pages[1]", "Objects"), IacObject())

            For Each obj As acObject In myObjArray
                'Check if it is a field object
                If obj("ObjectType").Equals(6) Then
                    MessageBox.Show($"acObjectTypeField found", $"Amyuni PDF Creator")

                    'text property is not empty and exist
                    If obj("Text") IsNot Nothing Then
                        'Retrieve text value
                        MessageBox.Show(obj("Text").ToString())
                    End If
                End If
            Next
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This code snippet illustrates how to extract contents of a PDF document using an object name
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnRetreiveTextValue_Click(sender As Object, e As EventArgs) Handles BtnRetreiveTextValue.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice_filled.pdf", "")

            'Retrieve values based on object names
            MessageBox.Show(axPDF.get_ObjectAttribute("BILLTO", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("SHIPTO", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("SALESPERSON", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("PONUMBER", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("SHIPDATE", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("ITEM1_QTY", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("ITEM1_DESC", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("ITEM1_UNIT_PRICE", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("ITEM1_AMOUNT", "Text").ToString())
            MessageBox.Show(axPDF.get_ObjectAttribute("TOTAL", "Text").ToString())
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This code snippet illustrates how to populate the contents of a PDF document using an object name.
    '''     This is typically used to fill form fields
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnSetTextValue_Click(sender As Object, e As EventArgs) Handles BtnSetTextValue.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")
            axPDF.set_ObjectAttribute("BILLTO", "Text",
                                      "Company Co." & Environment.NewLine & "1234 Amywhere St." & Environment.NewLine &
                                      "City, State" & Environment.NewLine & "USA")

            axPDF.set_ObjectAttribute("SHIPTO", "Text",
                                      "Company Co." & Environment.NewLine & "9999 Street St." & Environment.NewLine &
                                      "City, State" & Environment.NewLine & "USA")

            axPDF.set_ObjectAttribute("SALESPERSON", "Text", "John Smith")
            axPDF.set_ObjectAttribute("PONUMBER", "Text", "111-000-11")
            axPDF.set_ObjectAttribute("SHIPDATE", "Text", "Jan 1, 2012")
            axPDF.set_ObjectAttribute("ITEM1_QTY", "Text", "99")
            axPDF.set_ObjectAttribute("ITEM1_DESC", "Text", "New Widgets")
            axPDF.set_ObjectAttribute("ITEM1_UNIT_PRICE", "Text", "1.00")
            axPDF.set_ObjectAttribute("ITEM1_AMOUNT", "Text", "99.00")
            axPDF.set_ObjectAttribute("TOTAL", "Text", "99.00")

            axPDF.DoCommandTool(CommandToolConstants.acCommandToolRunDocument)

            axPDF.Save(requiredPath + "Resulting_Docs\acFileSaveAll.pdf", FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The ExportToExcel method is used to export a PDF document to Excel format. It is recommended to use this method
    '''     together with the OptimizeDocument method
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnExportToXLS_Click(sender As Object, e As EventArgs) Handles BtnExportToXLS.Click
        '===============================================================
        '            '    Optimization Level OptimizeLevel value
        '            '    No optimization 0
        '            '    Line optimization (Recommended) 1
        '            '    Paragraph optimization 2
        '
        '                'optimize document to line level before exporting
        '                .OptimizeDocument 1
        '			        
        '			
        '            Export Constants
        '            'acExcelExportDecimalSeparator_Comma = 2
        '            'acExcelExportOptionMultipleSheets = 1
        '            'acExcelExportOptionSingleSheet = 0
        '            ===============================================================


        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")

            axPDF.OptimizeDocument(1)
            axPDF.ExportToExcel(requiredPath & "\Resulting_Docs\ExportToExcel_resulting.xls",
                                acExcelExportOptions.acExcelExportOptionMultipleSheets)

            MessageBox.Show($"Export to XLS Done!")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The ExportToHTML method is used to export a PDF document to HTML format. It is recommended to use this method
    '''     together with the OptimizeDocument method
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnExportToHTML_Click(sender As Object, e As EventArgs) Handles BtnExportToHTML.Click
        '===============================================================
        '            ' The text inside a PDF file is usually split into multiple parts,
        '            ' a single sentence or paragraph can consist of multiple pieces of text
        '            ' positioned independently inside the PDF document. The Optimize method
        '            ' attempts to regroup lines or paragraphs prior to exporting the PDF file
        '            ' into another format, or to make the file easier to edit.
        '			
        '            ' No optimization = 0
        '            ' Line optimization (Recommended) = 1
        '            ' Paragraph optimization = 2
        '			        
        '			
        '            HTML Constants
        '            acHtmlExportOptionLayers = 1
        '            acHtmlExportOptionMultiplePages = 3
        '            acHtmlExportOptionSinglePage = 2
        '            ===============================================================


        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))
        Try
            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")

            axPDF.OptimizeDocument(1)

            axPDF.ExportToHTML(requiredPath & "\Resulting_Docs\ExportToHTML_resulting.html",
                               acHtmlExportOptions.acHtmlExportOptionMultiplePages)

            MessageBox.Show($"Export to HTML Done!")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The ExportToJPeg method is used to export a PDF document to multiple JPEG files. It is recommended to use this
    '''     method together with the OptimizeDocument method
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnExportToJPEG_Click(sender As Object, e As EventArgs) Handles BtnExportToJPEG.Click
        '===============================================================
        '                ' The text inside a PDF file is usually split into multiple parts,
        '                ' a single sentence or paragraph can consist of multiple pieces of text
        '                ' positioned independently inside the PDF document. The Optimize method
        '                ' attempts to regroup lines or paragraphs prior to exporting the PDF file
        '                ' into another format, or to make the file easier to edit.
        '			
        '                ' No optimization = 0
        '                ' Line optimization (Recommended) = 1
        '                ' Paragraph optimization = 2
        '			        
        '			
        '                JPEG Constants
        '                FileName
        '                    name of the file with .jpg extension to export to.
        '                Resolution
        '                    72, 150, 300, 600
        '                JPegLevel
        '                    from 1 (highest) to 9 (lowest) in the low order word
        '                ===============================================================

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")

            axPDF.OptimizeDocument(1)

            axPDF.ExportToJPeg(requiredPath & "\Resulting_Docs\ExportToJPEG_resulting.jpg", 300, 3)
            MessageBox.Show($"Export to JEPG Done!")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The ExportToRTF method is used to export a PDF document to RTF format. It is recommended to use this method
    '''     together with the OptimizeDocument method
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnExportToRTF_Click(sender As Object, e As EventArgs) Handles BtnExportToRTF.Click
        '===============================================================
        '                ' The text inside a PDF file is usually split into multiple parts,
        '                ' a single sentence or paragraph can consist of multiple pieces of text
        '                ' positioned independently inside the PDF document. The Optimize method
        '                ' attempts to regroup lines or paragraphs prior to exporting the PDF file
        '                ' into another format, or to make the file easier to edit.
        '			
        '                ' No optimization = 0
        '                ' Line optimization (Recommended) = 1
        '                ' Paragraph optimization = 2
        '			        
        '            FileName
        '                name of the file with .rtf extension to export to.
        '            Options
        '                Option							Value	Description
        '                acRtfExportOptionAdvancedRTF	0		Advanced RTF: using frames to position objects
        '                acRtfExportOptionFullRTF		1		Full RTF: Text, Graphics and images with no frames
        '                acRtfExportOptionRTFText		2		Formatted Text only
        '                acRtfExportOptionText			3		Simple text, non-formatted
        '            UseTabs
        '                Set this parameter True to enable tabs in the document, False (or 0) to replace tabs with spaces (Effective
        '                only for non-formatted simple text).
        '                ===============================================================

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")

            axPDF.OptimizeDocument(1)

            axPDF.ExportToRTF(requiredPath & "\Resulting_Docs\ExportToRTF_resulting.rtf",
                              acRtfExportOptions.acRtfExportOptionAdvancedRTF, 0)
            MessageBox.Show($"Export to RTF Done!")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The ExportToTiff method is used to export a PDF document to a single TIFF file. It is recommended to use this
    '''     method together with the OptimizeDocument method
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnExportToTIFF_Click(sender As Object, e As EventArgs) Handles BtnExportToTIFF.Click
        '===============================================================
        '                    ' The text inside a PDF file is usually split into multiple parts,
        '                    ' a single sentence or paragraph can consist of multiple pieces of text
        '                    ' positioned independently inside the PDF document. The Optimize method
        '                    ' attempts to regroup lines or paragraphs prior to exporting the PDF file
        '                    ' into another format, or to make the file easier to edit.
        '
        '                    ' No optimization = 0
        '                    ' Line optimization (Recommended) = 1
        '                    ' Paragraph optimization = 2
        '						
        '                FileName
        '                    name of the file with .tif extension to export to.
        '						
        '                Resolution
        '                72, 150, 300, 600
        '
        '                Options
        '
        '                0 = represents no compression
        '                1 to 9 = represents the Jpeg Compression level to use. Note: This not supported by all TIFF viewers
        '                10 = represents CCITT fax compression
        '				
        '                axPDF.OptimizeDocument = 1;
        '					
        '                All other values reserved for future use
        '            ===============================================================

        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")

            axPDF.ExportToTiff(requiredPath & "\Resulting_Docs\ExportToTiff_resulting.tif", 300, 10)
            MessageBox.Show($"Export to TIFF Done!")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     The ExportToXPS method is used to export a PDF document to XPS format.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnExportToXPS_Click(sender As Object, e As EventArgs) Handles BtnExportToXPS.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try
            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")

            axPDF.ExportToXPS(requiredPath & "\Resulting_Docs\ExportToXps_resulting.xps",
                              acXPSExportOptions.acXPSExportOptionsNone)

            MessageBox.Show($"Export to XPS Done!")
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This code snippet illustrates how to write metadata to the contents of a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnAddMetaData_Click(sender As Object, e As EventArgs) Handles BtnAddMetaData.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))

        Try

            axPDF.Open(requiredPath & "\Source_Docs\Sales_invoice.pdf", "")

            Dim sb As New StringBuilder()
            sb.Append("<rdf:Description>")
            'starting tag
            sb.Append("<myXLLtag>Amyuni XLM Tag</myXLLtag>")
            sb.Append("</rdf:Description>")
            'ending tag
            '0: No metadata stream
            '1: Basic XMP metadata  generated by PDF Creator
            '2: Custom metadata stream generated by the calling application
            '3: PDF/A compatible matadata stream (Acrobat 8)
            '4:PDF/A compatible


            'In this example we add basic XMP metadata to document
            axPDF.ObjectAttributeStr("Document", "Metadata", "1")

            'Here we are adding custom XML data
            'This is not in our documentation
            axPDF.ObjectAttributeStr("Document", "ExtraXMPMetadata", sb.ToString())


            axPDF.Save(requiredPath & "\Resulting_Docs\AddMetaData_resulting.pdf",
                       FileSaveOptionConstants.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub


    ''' <summary>
    '''     This code snippet illustrates how to read metadata to the contents of a PDF document
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub BtnReadMetaData_Click(sender As Object, e As EventArgs) Handles BtnReadMetaData.Click
        'get startup path for temp working files
        Dim requiredPath As String =
                Path.GetDirectoryName(
                    Path.GetDirectoryName(
                        Path.GetDirectoryName(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location))))


        Try
            Dim myMetaData As String

            axPDF.Open(requiredPath & "\Resulting_Docs\AddMetaData_resulting.pdf", "")

            'This returns the Metadata embeded in the document
            'This will also return an metadata added by ExtraXMPMetadata attribute
            myMetaData = axPDF.get_ObjectAttribute("Document", "MetadataStream").ToString()
            MessageBox.Show(myMetaData)

            'This returns metadata added by ExtraXMPMetadata attribute only
            myMetaData = axPDF.get_ObjectAttribute("Document", "ExtraXMPMetadata").ToString()

            MessageBox.Show(myMetaData)
        Catch ex As Exception

            'Metadata (the option)
            'MetadataStream (read/write string)
            'ExtraXMPMetadata (read/write XML string)

            MessageBox.Show(ex.Message)
        End Try
    End Sub
End Class
